//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtVersion: TEdit;
    Timer1: TTimer;
    Label2: TLabel;
    edtTime: TEdit;
    memoMsg2: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    edtIPAddress2: TEdit;
    btnExit: TButton;
    btnStart: TButton;
    btnStop: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  iRecCount  : Integer=0;
  iRecCount2 : Integer=0;
  Form1: TForm1;
  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin
     close();
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin

   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

procedure TForm1.btnStartClick(Sender: TObject);
var
   ReturnValue  : Integer;
  // strMsg       : string;
begin

   btnStart.Enabled :=false;
   btnStop.Enabled:=true;
   btnExit.Enabled:=false;

   //--- adding the first 9000 for streaming ----
   ReturnValue:=TCP_StartStream(PChar(edtIPAddress.Text),0);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('Connect Failure!, Error Code:' + IntToStr(ReturnValue) );
        exit;
   end;
   //--- adding the second 9000 for streaming ----
   ReturnValue:=TCP_StartStream(PChar(edtIPAddress2.Text),0);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('Connect Failure!, Error Code:' + IntToStr(ReturnValue) );
        exit;
   end;

   memoMsg.Lines.Clear();
   //--- Start getting  streaming data  ---
   Timer1.Interval:=StrToInt( edtTime.Text );
   Timer1.Enabled:=true;

end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
   Timer1.Enabled:=false;
   btnStart.Enabled :=true;
   btnStop.Enabled:=false;
   btnExit.Enabled:=true;
   TCP_StopStream();
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
//   ReturnValue      : Integer;
   StreamData       : TStreamData;
   StreamData2      : TStreamData;
begin

     if( (iRecCount mod 4)=3 ) then
     begin
        memoMsg.Lines.Clear();
     end;
     if( (iRecCount2 mod 4)=3 ) then
     begin
        memoMsg2.Lines.Clear();
     end;

     //--- Pooling FIRST ---
     if (TCP_ReadStreamData(PChar(edtIPAddress.Text),StreamData)=0) then
     begin
      inc(iRecCount);
      memoMsg.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount));
      memoMsg.Lines.Add('DIN:'+INTTOHEX(StreamData.DIN,4));
      memoMsg.Lines.Add('DUOT:'+INTTOHEX(StreamData.Dout,4));
      memoMsg.Lines.Add('   ');
     end;

     //--- Pooling SECOND ---
     if(TCP_ReadStreamData(PChar(edtIPAddress2.Text),StreamData2)=0) then
     begin
        inc(iRecCount2);
        memoMsg2.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount2));
        memoMsg2.Lines.Add('DIN:'+INTTOHEX(StreamData2.DIN,4));
        memoMsg2.Lines.Add('DUOT:'+INTTOHEX(StreamData2.Dout,4));
        memoMsg2.Lines.Add('   ');
    end;

end;





end.
